@extends('layouts.setup')
@section('content')
<div class="d-flex justify-content-center">
	<div class="card mt-4 text-dark wizard-form border-0 shadow-custom text-sm">
		<div class="card-header border-grey">
			<h3 class="card-title float-none text-center">
				Create Admin User
			</h3>
		</div>
		<div class="card-body justify-content-center d-flex">
			<div class="col-md-12">
				<div class="col-md-12">
					@if (\Session::has('success'))
						<div class="alert alert-success mb-3 text-center">
							<p class="mb-0">{{ \Session::get('success') }}</p>
						</div>
					@endif
				</div>
				<form action="{{ route('setup.create_user', $user->id) }}" method="post" autocomplete="off">
					{{ csrf_field() }}
						<div class="form-group">
							<label for="name" class="required">User Name</label>
							<input type="text" value="{{ $user->name }}" class="form-control @error('name') is-invalid @enderror" name="name" id="name">
							@error('name')
								<span class="d-block invalid-feedback">{{ $message }}</span>
							@enderror
						</div>

						<div class="form-group">
							<label for="name" class="email">User Email</label>
							<input type="text" value="{{ $user->email }}" class="form-control @error('email') is-invalid @enderror" name="email" id="email">
							@error('email')
								<span class="d-block invalid-feedback">{{ $message }}</span>
							@enderror
						</div>

						<div class="form-group">
							<label for="name" class="required">Password</label>
							<input type="password" value="{{ old('password') }}" class="form-control @error('password') is-invalid @enderror" name="password" id="password">
							@error('password')
								<span class="d-block invalid-feedback">{{ $message }}</span>
							@enderror
						</div>
						<button type="submit" class="btn btn-primary">Create User</button>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection
 
